/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: Gyroskop_23a.c
 *
 * Code generated for Simulink model 'Gyroskop_23a'.
 *
 * Model version                  : 1.0
 * Simulink Coder version         : 9.9 (R2023a) 19-Nov-2022
 * C/C++ source code generated on : Mon Jan 15 12:48:56 2024
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Gyroskop_23a.h"
#include "Gyroskop_23a_types.h"
#include "rtwtypes.h"
#include <string.h>
#include "Gyroskop_23a_private.h"
#include <stddef.h>
#include "rt_nonfinite.h"
#include <math.h>
#include <float.h>

/* Block signals (default storage) */
B_Gyroskop_23a_T Gyroskop_23a_B;

/* Continuous states */
X_Gyroskop_23a_T Gyroskop_23a_X;

/* Block states (default storage) */
DW_Gyroskop_23a_T Gyroskop_23a_DW;

/* Real-time model */
static RT_MODEL_Gyroskop_23a_T Gyroskop_23a_M_;
RT_MODEL_Gyroskop_23a_T *const Gyroskop_23a_M = &Gyroskop_23a_M_;

/* Forward declaration for local functions */
static codertarget_arduinobase_inter_T *G_arduinoMPU6050_arduinoMPU6050
  (codertarget_arduinobase_inter_T *obj);
static void Gyroskop_23a_SystemCore_setup(codertarget_arduinobase_inter_T *obj);

/*
 * This function updates continuous states using the ODE1 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE1_IntgData *id = (ODE1_IntgData *)rtsiGetSolverData(si);
  real_T *f0 = id->f[0];
  int_T i;
  int_T nXc = 1;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);
  rtsiSetdX(si, f0);
  Gyroskop_23a_derivatives();
  rtsiSetT(si, tnew);
  for (i = 0; i < nXc; ++i) {
    x[i] += h * f0[i];
  }

  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

real_T rt_modd_snf(real_T u0, real_T u1)
{
  real_T q;
  real_T y;
  boolean_T yEq;
  y = u0;
  if (u1 == 0.0) {
    if (u0 == 0.0) {
      y = u1;
    }
  } else if (rtIsNaN(u0) || rtIsNaN(u1) || rtIsInf(u0)) {
    y = (rtNaN);
  } else if (u0 == 0.0) {
    y = 0.0 / u1;
  } else if (rtIsInf(u1)) {
    if ((u1 < 0.0) != (u0 < 0.0)) {
      y = u1;
    }
  } else {
    y = fmod(u0, u1);
    yEq = (y == 0.0);
    if ((!yEq) && (u1 > floor(u1))) {
      q = fabs(u0 / u1);
      yEq = !(fabs(q - floor(q + 0.5)) > DBL_EPSILON * q);
    }

    if (yEq) {
      y = u1 * 0.0;
    } else if ((u0 < 0.0) != (u1 < 0.0)) {
      y += u1;
    }
  }

  return y;
}

static codertarget_arduinobase_inter_T *G_arduinoMPU6050_arduinoMPU6050
  (codertarget_arduinobase_inter_T *obj)
{
  codertarget_arduinobase_inter_T *b_obj;
  obj->I2CReadWriteError = 0U;
  obj->InitError = false;
  obj->isInitialized = 0L;
  obj->SampleTime = -1.0;
  obj->IsFirstStep = false;
  b_obj = obj;
  obj->i2cObjmpu.DefaultMaximumBusSpeedInHz = 400000.0;
  obj->i2cObjmpu.isInitialized = 0L;
  obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE = NULL;
  obj->i2cObjmpu.matlabCodegenIsDeleted = false;
  obj->matlabCodegenIsDeleted = false;
  return b_obj;
}

static void Gyroskop_23a_SystemCore_setup(codertarget_arduinobase_inter_T *obj)
{
  MW_I2C_Mode_Type modename;
  uint32_T i2cname;
  uint8_T SwappedDataBytes[2];
  uint8_T b_SwappedDataBytes[2];
  uint8_T SwappedDataBytes_0;
  uint8_T regSet;
  uint8_T status;
  obj->isInitialized = 1L;
  obj->InitializationFlag = true;
  modename = MW_I2C_MASTER;
  i2cname = 0;
  obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE = MW_I2C_Open(i2cname, modename);
  obj->i2cObjmpu.BusSpeed = 100000UL;
  MW_I2C_SetBusSpeed(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE,
                     obj->i2cObjmpu.BusSpeed);
  regSet = 128U;
  memcpy((void *)&b_SwappedDataBytes[1], (void *)&regSet, (size_t)1 * sizeof
         (uint8_T));
  b_SwappedDataBytes[0] = 107U;
  memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)2
         * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes[0], 2UL, false, false);
  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  MW_delay_in_milliseconds(1UL);
  regSet = 0U;
  memcpy((void *)&b_SwappedDataBytes[1], (void *)&regSet, (size_t)1 * sizeof
         (uint8_T));
  b_SwappedDataBytes[0] = 107U;
  memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)2
         * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes[0], 2UL, false, false);
  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  MW_delay_in_milliseconds(100UL);
  status = 117U;
  memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
         (uint8_T));
  status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes_0, 1UL, true, false);
  if (status == 0) {
    MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                      &SwappedDataBytes_0, 1UL, false, true);
    memcpy((void *)&regSet, (void *)&SwappedDataBytes_0, (size_t)1 * sizeof
           (uint8_T));
  } else {
    regSet = 0U;
  }

  if (status != 0) {
    if (obj->InitializationFlag) {
      obj->InitError = true;
    } else if (obj->I2CReadWriteError == 0) {
      obj->I2CReadWriteError = status;
    }
  }

  obj->MPUConnect = (regSet == 104);
  if (obj->MPUConnect) {
    regSet = 0U;
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&regSet, (size_t)1 * sizeof
           (uint8_T));
    b_SwappedDataBytes[0] = 25U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 27U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&regSet, (void *)&SwappedDataBytes_0, (size_t)1 * sizeof
             (uint8_T));
    } else {
      regSet = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    regSet = (uint8_T)(regSet & 231);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&regSet, (size_t)1 * sizeof
           (uint8_T));
    b_SwappedDataBytes[0] = 27U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    status = 26U;
    memcpy((void *)&SwappedDataBytes_0, (void *)&status, (size_t)1 * sizeof
           (uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes_0, 1UL, true, false);
    if (status == 0) {
      MW_I2C_MasterRead(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
                        &SwappedDataBytes_0, 1UL, false, true);
      memcpy((void *)&regSet, (void *)&SwappedDataBytes_0, (size_t)1 * sizeof
             (uint8_T));
    } else {
      regSet = 0U;
    }

    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }

    regSet = (uint8_T)((regSet & 248) | 1);
    memcpy((void *)&b_SwappedDataBytes[1], (void *)&regSet, (size_t)1 * sizeof
           (uint8_T));
    b_SwappedDataBytes[0] = 26U;
    memcpy((void *)&SwappedDataBytes[0], (void *)&b_SwappedDataBytes[0], (size_t)
           2 * sizeof(uint8_T));
    status = MW_I2C_MasterWrite(obj->i2cObjmpu.I2CDriverObj.MW_I2C_HANDLE, 104UL,
      &SwappedDataBytes[0], 2UL, false, false);
    if (status != 0) {
      if (obj->InitializationFlag) {
        obj->InitError = true;
      } else if (obj->I2CReadWriteError == 0) {
        obj->I2CReadWriteError = status;
      }
    }
  } else {
    obj->InitError = true;
  }

  obj->InitializationFlag = false;
  obj->isSetupComplete = true;
}

/* Model step function */
void Gyroskop_23a_step(void)
{
  /* local block i/o variables */
  real_T rtb_Integrator;
  i_codertarget_arduinobase_int_T *obj;
  int16_T i;
  uint8_T b_RegisterValue[6];
  uint8_T output_raw[6];
  uint8_T SwappedDataBytes;
  uint8_T status;
  if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&Gyroskop_23a_M->solverInfo,
                          ((Gyroskop_23a_M->Timing.clockTick0+1)*
      Gyroskop_23a_M->Timing.stepSize0));
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Gyroskop_23a_M)) {
    Gyroskop_23a_M->Timing.t[0] = rtsiGetT(&Gyroskop_23a_M->solverInfo);
  }

  /* Outputs for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Outputs for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* MATLABSystem: '<S1>/Base sensor block' */
  if (Gyroskop_23a_DW.obj.SampleTime !=
      Gyroskop_23a_P.MPU6050IMUSensor_SampleTime) {
    Gyroskop_23a_DW.obj.SampleTime = Gyroskop_23a_P.MPU6050IMUSensor_SampleTime;
  }

  /* End of Outputs for SubSystem: '<Root>/MPU6050 IMU Sensor' */
  if (!Gyroskop_23a_DW.obj.IsFirstStep) {
    MW_getCurrentTime_in_milliseconds();
    Gyroskop_23a_DW.obj.IsFirstStep = true;
  }

  Gyroskop_23a_DW.obj.I2CReadWriteError = 0U;
  obj = &Gyroskop_23a_DW.obj.i2cObjmpu;
  status = 67U;
  memcpy((void *)&SwappedDataBytes, (void *)&status, (size_t)1 * sizeof(uint8_T));
  status = MW_I2C_MasterWrite(obj->I2CDriverObj.MW_I2C_HANDLE, 104UL,
    &SwappedDataBytes, 1UL, true, false);
  if (status == 0) {
    MW_I2C_MasterRead(obj->I2CDriverObj.MW_I2C_HANDLE, 104UL, &output_raw[0],
                      6UL, false, true);
    memcpy((void *)&b_RegisterValue[0], (void *)&output_raw[0], (size_t)6 *
           sizeof(uint8_T));
  } else {
    for (i = 0; i < 6; i++) {
      b_RegisterValue[i] = 0U;
    }
  }

  if (status != 0) {
    if (Gyroskop_23a_DW.obj.InitializationFlag) {
      Gyroskop_23a_DW.obj.InitError = true;
    } else if (Gyroskop_23a_DW.obj.I2CReadWriteError == 0) {
      Gyroskop_23a_DW.obj.I2CReadWriteError = status;
    }
  }

  if (Gyroskop_23a_DW.obj.InitError) {
    /* S-Function (sdspmultiportsel): '<Root>/Multiport Selector' */
    Gyroskop_23a_B.MultiportSelector = 0.0;
  } else {
    /* S-Function (sdspmultiportsel): '<Root>/Multiport Selector' */
    Gyroskop_23a_B.MultiportSelector = (real_T)(b_RegisterValue[0] << 8 |
      b_RegisterValue[1]) * 0.00762939453125;
  }

  /* End of MATLABSystem: '<S1>/Base sensor block' */
  /* End of Outputs for SubSystem: '<Root>/MPU6050 IMU Sensor' */
  if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {
  }

  /* FromWorkspace: '<Root>/From Workspace' */
  {
    real_T *pDataValues = (real_T *) Gyroskop_23a_DW.FromWorkspace_PWORK.DataPtr;
    rtb_Integrator = pDataValues[0];
  }

  /* Sum: '<Root>/Sum1' */
  Gyroskop_23a_B.Sum1 = Gyroskop_23a_B.MultiportSelector - rtb_Integrator;
  if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {
  }

  /* Integrator: '<Root>/Integrator' */
  rtb_Integrator = Gyroskop_23a_X.Integrator_CSTATE;

  /* Math: '<Root>/Mod' incorporates:
   *  Constant: '<Root>/Constant1'
   */
  Gyroskop_23a_B.Mod = rt_modd_snf(rtb_Integrator,
    Gyroskop_23a_P.Constant1_Value);
  if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {
  }

  if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {
    {                                  /* Sample time: [0.0s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Gyroskop_23a_M->Timing.clockTick0 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(0,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }

    if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {/* Sample time: [0.0005s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Gyroskop_23a_M->Timing.clockTick1 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(1,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }
  }                                    /* end MajorTimeStep */

  if (rtmIsMajorTimeStep(Gyroskop_23a_M)) {
    rt_ertODEUpdateContinuousStates(&Gyroskop_23a_M->solverInfo);

    /* Update absolute time for base rate */
    /* The "clockTick0" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick0"
     * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
     * overflow during the application lifespan selected.
     */
    ++Gyroskop_23a_M->Timing.clockTick0;
    Gyroskop_23a_M->Timing.t[0] = rtsiGetSolverStopTime
      (&Gyroskop_23a_M->solverInfo);

    {
      /* Update absolute timer for sample time: [0.0005s, 0.0s] */
      /* The "clockTick1" counts the number of times the code of this task has
       * been executed. The resolution of this integer timer is 0.0005, which is the step size
       * of the task. Size of "clockTick1" ensures timer will not overflow during the
       * application lifespan selected.
       */
      Gyroskop_23a_M->Timing.clockTick1++;
    }
  }                                    /* end MajorTimeStep */
}

/* Derivatives for root system: '<Root>' */
void Gyroskop_23a_derivatives(void)
{
  XDot_Gyroskop_23a_T *_rtXdot;
  _rtXdot = ((XDot_Gyroskop_23a_T *) Gyroskop_23a_M->derivs);

  /* Derivatives for Integrator: '<Root>/Integrator' */
  _rtXdot->Integrator_CSTATE = Gyroskop_23a_B.Sum1;
}

/* Model initialize function */
void Gyroskop_23a_initialize(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Gyroskop_23a_M->solverInfo,
                          &Gyroskop_23a_M->Timing.simTimeStep);
    rtsiSetTPtr(&Gyroskop_23a_M->solverInfo, &rtmGetTPtr(Gyroskop_23a_M));
    rtsiSetStepSizePtr(&Gyroskop_23a_M->solverInfo,
                       &Gyroskop_23a_M->Timing.stepSize0);
    rtsiSetdXPtr(&Gyroskop_23a_M->solverInfo, &Gyroskop_23a_M->derivs);
    rtsiSetContStatesPtr(&Gyroskop_23a_M->solverInfo, (real_T **)
                         &Gyroskop_23a_M->contStates);
    rtsiSetNumContStatesPtr(&Gyroskop_23a_M->solverInfo,
      &Gyroskop_23a_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&Gyroskop_23a_M->solverInfo,
      &Gyroskop_23a_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&Gyroskop_23a_M->solverInfo,
      &Gyroskop_23a_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&Gyroskop_23a_M->solverInfo,
      &Gyroskop_23a_M->periodicContStateRanges);
    rtsiSetErrorStatusPtr(&Gyroskop_23a_M->solverInfo, (&rtmGetErrorStatus
      (Gyroskop_23a_M)));
    rtsiSetRTModelPtr(&Gyroskop_23a_M->solverInfo, Gyroskop_23a_M);
  }

  rtsiSetSimTimeStep(&Gyroskop_23a_M->solverInfo, MAJOR_TIME_STEP);
  Gyroskop_23a_M->intgData.f[0] = Gyroskop_23a_M->odeF[0];
  Gyroskop_23a_M->contStates = ((X_Gyroskop_23a_T *) &Gyroskop_23a_X);
  rtsiSetSolverData(&Gyroskop_23a_M->solverInfo, (void *)
                    &Gyroskop_23a_M->intgData);
  rtsiSetIsMinorTimeStepWithModeChange(&Gyroskop_23a_M->solverInfo, false);
  rtsiSetSolverName(&Gyroskop_23a_M->solverInfo,"ode1");
  rtmSetTPtr(Gyroskop_23a_M, &Gyroskop_23a_M->Timing.tArray[0]);
  rtmSetTFinal(Gyroskop_23a_M, -1);
  Gyroskop_23a_M->Timing.stepSize0 = 0.0005;

  /* External mode info */
  Gyroskop_23a_M->Sizes.checksums[0] = (2958835129U);
  Gyroskop_23a_M->Sizes.checksums[1] = (284626618U);
  Gyroskop_23a_M->Sizes.checksums[2] = (3973061432U);
  Gyroskop_23a_M->Sizes.checksums[3] = (1040330557U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[3];
    Gyroskop_23a_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(Gyroskop_23a_M->extModeInfo,
      &Gyroskop_23a_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(Gyroskop_23a_M->extModeInfo,
                        Gyroskop_23a_M->Sizes.checksums);
    rteiSetTPtr(Gyroskop_23a_M->extModeInfo, rtmGetTPtr(Gyroskop_23a_M));
  }

  /* Start for FromWorkspace: '<Root>/From Workspace' */
  {
    static real_T pTimeValues0[] = { 0.0 } ;

    static real_T pDataValues0[] = { -6.93723453552316 };

    Gyroskop_23a_DW.FromWorkspace_PWORK.TimePtr = (void *) pTimeValues0;
    Gyroskop_23a_DW.FromWorkspace_PWORK.DataPtr = (void *) pDataValues0;
    Gyroskop_23a_DW.FromWorkspace_IWORK.PrevIndex = 0;
  }

  /* InitializeConditions for Integrator: '<Root>/Integrator' */
  Gyroskop_23a_X.Integrator_CSTATE = Gyroskop_23a_P.Integrator_IC;

  /* SystemInitialize for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Start for MATLABSystem: '<S1>/Base sensor block' */
  Gyroskop_23a_DW.obj.i2cObjmpu.matlabCodegenIsDeleted = true;
  Gyroskop_23a_DW.obj.matlabCodegenIsDeleted = true;
  G_arduinoMPU6050_arduinoMPU6050(&Gyroskop_23a_DW.obj);

  /* Start for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  Gyroskop_23a_DW.obj.SampleTime = Gyroskop_23a_P.MPU6050IMUSensor_SampleTime;

  /* End of Start for SubSystem: '<Root>/MPU6050 IMU Sensor' */
  Gyroskop_23a_SystemCore_setup(&Gyroskop_23a_DW.obj);

  /* End of SystemInitialize for SubSystem: '<Root>/MPU6050 IMU Sensor' */
}

/* Model terminate function */
void Gyroskop_23a_terminate(void)
{
  i_codertarget_arduinobase_int_T *obj;

  /* Terminate for Atomic SubSystem: '<Root>/MPU6050 IMU Sensor' */
  /* Terminate for MATLABSystem: '<S1>/Base sensor block' */
  if (!Gyroskop_23a_DW.obj.matlabCodegenIsDeleted) {
    Gyroskop_23a_DW.obj.matlabCodegenIsDeleted = true;
    if ((Gyroskop_23a_DW.obj.isInitialized == 1L) &&
        Gyroskop_23a_DW.obj.isSetupComplete) {
      obj = &Gyroskop_23a_DW.obj.i2cObjmpu;
      MW_I2C_Close(obj->I2CDriverObj.MW_I2C_HANDLE);
    }
  }

  obj = &Gyroskop_23a_DW.obj.i2cObjmpu;
  if (!obj->matlabCodegenIsDeleted) {
    obj->matlabCodegenIsDeleted = true;
    if (obj->isInitialized == 1L) {
      obj->isInitialized = 2L;
    }
  }

  /* End of Terminate for MATLABSystem: '<S1>/Base sensor block' */
  /* End of Terminate for SubSystem: '<Root>/MPU6050 IMU Sensor' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
